package com.ejie.aa17a.service.impl;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.ejie.aa17a.dao.iface.Aa17aContaminanteEstacionDao;
import com.ejie.aa17a.model.Aa17aContaminanteEstacion;
import com.ejie.aa17a.service.iface.Aa17aContaminanteEstacionService;

/**
 * Aa17aContaminanteEstacionServiceImpl generated by UDA, 18-dic-2013 15:36:14.
 * 
 * @author UDA
 */

public class Aa17aContaminanteEstacionServiceImpl implements Aa17aContaminanteEstacionService {

	private static final Logger logger = LoggerFactory.getLogger(Aa17aContaminanteEstacionServiceImpl.class);

	private Aa17aContaminanteEstacionDao aa17aContaminanteEstacionDao;

	/**
	 * Devuelve los contaminantes de una estacion
	 * 
	 * @param aa17aContaminanteEstacion
	 *            Aa17aContaminanteEstacion
	 * @return List
	 */
	public List<Aa17aContaminanteEstacion> getContaminantes(Aa17aContaminanteEstacion aa17aContaminanteEstacion) {
		return (List<Aa17aContaminanteEstacion>) this.aa17aContaminanteEstacionDao.getContaminantes(aa17aContaminanteEstacion);
	}

	/**
	 * Devuelve los datos de una estacion y un contaminante
	 * 
	 * @param aa17acontaminanteestacion
	 *            Aa17aContaminanteEstacion
	 * @return List<Aa17aContaminanteEstacion>
	 */
	public Aa17aContaminanteEstacion getContaminanteEstacion(Aa17aContaminanteEstacion aa17acontaminanteestacion) {
		return (Aa17aContaminanteEstacion) this.aa17aContaminanteEstacionDao.getContaminanteEstacion(aa17acontaminanteestacion);
	}

	/**
	 * Setter method for Aa17aContaminanteEstacionDao.
	 * 
	 * @param aa17aContaminanteEstacionDao
	 *            Aa17aContaminanteEstacionDao
	 * @return
	 */
	public void setAa17aContaminanteEstacionDao(Aa17aContaminanteEstacionDao aa17aContaminanteEstacionDao) {
		Aa17aContaminanteEstacionServiceImpl.logger.info("Setting Dependency " + aa17aContaminanteEstacionDao);
		this.aa17aContaminanteEstacionDao = aa17aContaminanteEstacionDao;
	}
}
